<?php

use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Broadcast;


/*
|--------------------------------------------------------------------------
| Broadcast Channels
|--------------------------------------------------------------------------
|
| Here you may register all of the event broadcasting channels that your
| application supports. The given channel authorization callbacks are
| used to check if an authenticated user can listen to the channel.
|
*/

Broadcast::channel('notification.{receiver_id}', function ($user) {
    if (Auth::check()) {
        return ['id' => $user->id, 'name' => $user->name];
    }
});

Broadcast::channel('signature.{file_version_id}', function ($user) {
    if (Auth::check()) {
        return ['id' => $user->id, 'name' => $user->name];
    }
});