<?php

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Route;
use Suiterus\Dms\Models\GenerateFileLink;
use App\Http\Controllers\Auth\UserController;
use App\Http\Controllers\Auth\LoginController;
use App\Http\Controllers\Auth\OAuthController;
use App\Http\Controllers\ApplicationController;
use App\Http\Controllers\DocumentLogController;
use App\Http\Controllers\EmployeeAPIController;
use App\Http\Controllers\Auth\RegisterController;

//developer controllers
use App\Http\Controllers\v2\Roles\RoleController;
use Suiterus\Adg\Controllers\SM\SectorController;
use App\Http\Controllers\Role\SwitchRoleController;
use App\Http\Controllers\Settings\ProfileController;

//System Controllers


//Financial
use App\Http\Controllers\Auth\VerificationController;
use App\Http\Controllers\Settings\PasswordController;
use App\Http\Controllers\v2\Systems\SystemController;
use App\Http\Controllers\Auth\ResetPasswordController;
use App\Http\Controllers\Auth\ForgotPasswordController;
use App\Http\Controllers\FDG\AM\CompanyController as CC;


//Procurement
use App\Http\Controllers\PDG\CP\ProjectController as P_PC;
use App\Http\Controllers\FDG\AM\FiscalYearController as FY;
use App\Http\Controllers\FDG\AM\FinanceBookController as FB;

//use App\Http\Controllers\Auth\SampleBackend;

//Human Resource
//use App\Http\Controllers\ApplicantAccountController as AA_C;
//use App\Http\Controllers\PositionController as PC_C;
//HR-JOBPORTAL
use App\Http\Controllers\FDG\AM\PaymentTermController as PT;
//use App\Http\Controllers\ApplicantAccountController as AA_C;

//backend
// use App\Http\Controllers\ApplicantExamInterviewController as AEI_C;


/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

use App\Http\Controllers\Profile\ProfileBasicInfoController;
use App\Http\Controllers\Profile\ProfileContactInfoController;
use App\Http\Controllers\Profile\UserProfilePictureController;
use App\Http\Controllers\Systems\NotificationController as SNC;
use App\Http\Controllers\DeveloperTools\RolesController as DT_RC;
use App\Http\Controllers\DeveloperTools\ToolsController as DT_TC;
use App\Http\Controllers\DeveloperTools\UsersController as DT_UC;
use App\Http\Controllers\FDG\AM\AccountingPeriodController as AP;
use App\Http\Controllers\PDG\CP\ProjectHistoryController as P_PH;
use App\Http\Controllers\ApplicantExamScheduleController as AES_C;
use App\Http\Controllers\PDG\CP\EvaluationOfPpmpController as P_EP;
use App\Http\Controllers\FDG\AM\AccountingDimensionController as AD;
use Suiterus\Dms\Controllers\GenerateLink\GenerateFileLinkController;
use Suiterus\Dms\Controllers\Configuration\ConfigHeaderLogoController;
use Suiterus\Dms\Controllers\GenerateLink\GenerateDriveLinkController;
use App\Http\Controllers\DeveloperTools\PermissionsController as DT_PC;
use Suiterus\Dms\Controllers\Configuration\ConfigLoginHeaderController;

Route::get('test', function () {
    return "tests";
});

Route::get('fetch_logo_path', [ConfigHeaderLogoController::class, 'fetch_path']);
Route::get('fetch-login-header', [ConfigLoginHeaderController::class, 'fetchPath']);
Route::post('download_logo', [ConfigHeaderLogoController::class, 'file_download']);
Route::post('download-login-logo', [ConfigLoginHeaderController::class, 'download']);

Route::post('email/resend', [VerificationController::class, 'resend']);
Route::post('email/verify/{user}', [VerificationController::class, 'verify'])->name('verification.verify');

Route::group(['middleware' => 'auth:api'], function () {

    Route::post('event/create_notification', [SNC::class, 'createNotification']);
    Route::post('event/delete_notification', [SNC::class, 'deleteNotification']);
    Route::post('event/get_all_notifications', [SNC::class, 'getAllNotifications']);
    Route::get('event/get_unread_notifications', [SNC::class, 'getUnreadNotification']);
    Route::get('event/get_read_notifications', [SNC::class, 'getReadNotification']);
    Route::get('event/get_new_notifications', [SNC::class, 'getNewNotification']);
    Route::get('event/get_old_notifications', [SNC::class, 'getOldNotification']);
    Route::get('event/get_count_all_unread_notification', [SNC::class, 'getCountAllUnreadNotification']);
    Route::post('event/mark_notification_as_read', [SNC::class, 'markNotificationAsRead']);
    Route::post('event/mark_all_today_notification_as_read', [SNC::class, 'markAllTodayNotificationAsRead']);
    Route::post('event/mark_notification_as_unread', [SNC::class, 'markNotificationAsUnread']);

    Route::get('auth-module', [RoleController::class, 'authModule']);

    Route::group(['prefix' => 'v2'], function () {
        Route::group(['prefix' => 'systems', 'middleware' => ['module:System Management']], function () {
            Route::post('/get-by-names', [SystemController::class, 'getSystemByNames']);
            Route::get('/{system_id}', [SystemController::class, 'show']);
        });
        Route::group(['prefix' => 'role', 'middleware' => ['module:Role Management']], function () {
            Route::get('/{id}', [RoleController::class, 'show']);
            Route::put('/', [RoleController::class, 'update']);
        });
    });

    Route::put('switch-role/{role_id}', [SwitchRoleController::class, 'update']);

    Route::group(['prefix' => 'logs', 'middleware' => ['module:Audit Trail']], function () {
        Route::post('paginate-activities', [DocumentLogController::class, 'paginate']);
        Route::get('fetch-log-type', [DocumentLogController::class, 'fetchLogType']);
    });

    Route::post('sync-account', [UserController::class, 'syncAccount']);

    Route::post('fetch-employees-paginate', [UserController::class, 'fetchEmployees']);
    Route::post('list-employees', [UserController::class, 'listEmployees']);

    Route::group(['prefix' => 'profile'], function () {
        Route::post('create-basic-info', [ProfileBasicInfoController::class, 'create']);
        Route::put('update-contact-info', [ProfileContactInfoController::class, 'update']);
        Route::post('update-profile-picture', [UserProfilePictureController::class, 'create']);
        Route::post('fetch-profile-picture', [UserProfilePictureController::class, 'fetchProfilePicture']);
        Route::delete('delete-profile-picture', [UserProfilePictureController::class, 'delete']);
    });
    Route::post('logout', [LoginController::class, 'logout']);
    Route::get('user', [UserController::class, 'current']);
    Route::get('fetch_sector_type', [SectorController::class, 'fetch_sector_type']);
    Route::post('update_sector_type', [SectorController::class, 'update_sector_type']);

    // To be used by SRIT
    Route::get('external/employee-profile', [EmployeeAPIController::class, 'getEmployeeData'])->middleware(['role:Developer']);

    Route::patch('settings/profile', [ProfileController::class, 'update']);
    Route::patch('settings/password', [PasswordController::class, 'update']);
    Route::post('settings/password-valid', [PasswordController::class, 'passwordValid']);

    //functions
    Route::group(['prefix' => 'functions'], function () {

        Route::get('user', [UserController::class, 'fetchUsers']);

        //get own Notifications
        route::post('ownNotifications', [SNC::class, 'ownNotifications']);
        //get more own Notifications
        route::post('moreOwnNotifications', [SNC::class, 'MoreOwnNotifications']);
        //update dark mode
        route::post('updateDarkMode', [Controller::class, 'updateDarkMode']);
        //test own Notifications
        route::get('testNotif', [SNC::class, 'testNotif']);
        //developer tools
        Route::group(['middleware' => []], function () {
            //fetch all roles and permissions
            //roles
            Route::middleware('module:User Management')->group(function () {
                Route::post('roles/all', [DT_TC::class, 'role_list']);
                //roles
                Route::post('permissions/all', [DT_TC::class, 'permission_list']);
                //user management
                Route::group(['prefix' => 'users'], function () {
                    //list
                    Route::post('list', [DT_UC::class, 'init_list']);
                    //list
                    Route::post('search', [DT_UC::class, 'search_list']);
                    //create
                    Route::post('create', [DT_UC::class, 'create']);
                    //update
                    Route::post('update', [DT_UC::class, 'update']);
                    //ban process
                    Route::post('ban/process', [DT_UC::class, 'ban_process']);
                });
            });
            //role management
            Route::group(['prefix' => 'roles', 'middleware' => ['module:Role Management']], function () {
                //list
                Route::post('list', [DT_RC::class, 'init_list']);
                //list
                Route::post('search', [DT_RC::class, 'search_list']);
                //create
                Route::post('create', [DT_RC::class, 'create']);
                //update
                Route::post('update', [DT_RC::class, 'update']);
                //delete
                Route::post('delete', [DT_RC::class, 'delete']);
            });
            //permission management
            Route::group(['prefix' => 'permissions', 'middleware' => ['module:Permission Management']], function () {
                //list
                Route::post('list', [DT_PC::class, 'init_list']);
                //list
                Route::post('search', [DT_PC::class, 'search_list']);
                //create
                Route::post('create', [DT_PC::class, 'create']);
                //update
                Route::post('update', [DT_PC::class, 'update']);
                //delete
                Route::post('delete', [DT_PC::class, 'delete']);
            });
        });

        //FDG
        // Route::group([ 'prefix' => 'financial'/* , 'middleware' => [ 'role:developer|Junior Accountant' ] */ ], function(){
        //     //Accounting Masters Routes
        //     Route::group([ 'prefix' => 'am', 'middleware' => [] ],function(){
        //         //company routes
        //         Route::prefix('company')->group(function(){
        //             //create
        //             Route::post('create', [ CC::class, 'create_company' ])->middleware('permission:can create company');
        //             //init list
        //             Route::post('list', [ CC::class, 'init_list_company' ])->middleware('permission:can list company');
        //             //search
        //             Route::post('search', [ CC::class, 'search_company' ])->middleware('permission:can search company');
        //             //edit
        //             Route::post('edit', [CC::class, 'edit_company']);
        //             //view
        //             Route::post('view', [ CC::class, 'view_company' ]);
        //             //delete
        //             Route::post('delete', [ CC::class, 'delete_company' ]);

        //             //Trashed
        //             //Init list
        //             Route::post('deleted/list', [ CC::class, 'init_list_deleted_company']);
        //             //Restore
        //             Route::post('deleted/restore', [ CC::class, 'restore_deleted_company']);
        //             //Delete
        //             Route::post('deleted/delete', [ CC::class, 'delete_deleted_company']);


        //         });
        //          //fiscal year
        //          Route::prefix('fiscalyear')->group(function(){
        //             //create
        //             Route::post('create', [FY::class, 'create_fiscal'])->middleware('permission:can create fiscal year');
        //             //init list
        //             Route::post('list', [ FY::class, 'init_list_fiscal'])->middleware('permission:can list fiscal year');
        //             //search
        //             Route::post('search', [FY::class, 'search_fiscal'])->middleware('permission:can search fiscal year');
        //             //search company
        //             Route::post('company/search', [ FY::class, 'search_company' ]);
        //             //edit
        //             Route::post('edit', [FY::class, 'edit_fiscal']);
        //             //view
        //             Route::post('view', [ FY::class, 'view_fiscal' ]);
        //             //delete
        //             Route::post('delete', [ FY::class, 'delete_fiscal' ]);


        //             //Trashed
        //             //Init list
        //             Route::post('deleted/list', [ FY::class, 'init_list_deleted_fiscal']);
        //             //Restore
        //             Route::post('deleted/restore', [ FY::class, 'restore_deleted_fiscal']);
        //             //Delete
        //             Route::post('deleted/delete', [ FY::class, 'delete_deleted_fiscal']);


        //         });
        //         //Accounting Period
        //         Route::prefix('accountingperiod')->group(function(){
        //             //create
        //             Route::post('create', [AP::class, 'create'])->middleware('permission:can create accounting period');
        //             //list
        //             Route::post('list', [AP::class, 'init_list_accounting_period'])->middleware('permission:can list accounting period');
        //             //search
        //             Route::post('search', [AP::class, 'search_accounting_period'])->middleware('permission:can search accounting period');
        //             //search company
        //             Route::post('company/search', [ AP::class, 'search_company' ])->middleware('permission:can search company accounting period');
        //             //edit
        //             Route::post('edit', [AP::class, 'edit_accounting_period']);
        //             //view
        //             Route::post('view', [ AP::class, 'view_accounting_period' ]);
        //             //delete
        //             Route::post('delete', [ AP::class, 'delete_accounting_period']);


        //             //Trashed
        //             //Init list
        //             Route::post('deleted/list', [ AP::class, 'init_list_deleted_accounting_period']);
        //             //Restore
        //             Route::post('deleted/restore', [ AP::class, 'restore_deleted_accounting_period']);
        //             //Delete
        //             Route::post('deleted/delete', [ AP::class, 'delete_deleted_accounting_period']);
        //         });




        //         //accounting dimension routes
        //         Route::prefix('accountingdimension')->group(function(){
        //             //create
        //             Route::post('create', [AD::class, 'create'])->middleware('permission:can create accounting dimension');
        //             //list
        //             Route::post('list', [AD::class, 'init_list_accounting_dimension'])->middleware('permission:can list accounting dimension');
        //             //search
        //             Route::post('search', [AD::class, 'search_accounting_dimension'])->middleware('permission:can search accounting dimension');
        //             //search company
        //             Route::post('company/search', [ AD::class, 'search_company' ]);
        //             //edit
        //             Route::post('edit', [AD::class, 'edit_accounting_dimension']);
        //             //view
        //             Route::post('view', [ AD::class, 'view_accounting_dimension' ]);
        //             //delete
        //             Route::post('delete', [ AD::class, 'delete_accounting_dimension' ]);

        //             // Trashed
        //             //init list
        //             Route::post('deleted/list', [ AD::class, 'init_list_deleted_accounting_dimension' ]);
        //             //restore
        //             Route::post('deleted/restore', [ AD::class, 'restore_deleted_accounting_dimension']);
        //             //delete
        //             Route::post('deleted/delete', [ AD::class, 'delete_deleted_accounting_dimension']);
        //         });

        //         //finance book routes
        //         Route::prefix('financebook')->group(function() {
        //             //create
        //             Route::post('create', [FB::class, 'create_finance_book'])->middleware('permission:can create finance book');
        //             //init list
        //             Route::post('list', [FB::class, 'init_list_finance_book'])->middleware('permission:can list finance book');
        //             //search
        //             Route::post('search', [FB::class, 'search_finance_book'])->middleware('permission:can search finance book');
        //             //edit
        //             Route::post('edit', [FB::class, 'edit_finance_book']);
        //             //view
        //             Route::post('view', [ FB::class, 'view_finance_book' ]);
        //             //delete
        //             Route::post('delete', [ FB::class, 'delete_finance_book' ]);

        //             // Trashed
        //             //init list
        //             Route::post('deleted/list', [ FB::class, 'init_list_deleted_finance_book' ]);
        //             //restore
        //             Route::post('deleted/restore', [ FB::class, 'restore_deleted_finance_book']);
        //             //delete
        //             Route::post('deleted/delete', [ FB::class, 'delete_deleted_finance_book']);
        //         });

        //         //payment term routes
        //         Route::prefix('payment_term')->group(function(){
        //             //create
        //             Route::post('create', [ PT::class, 'create_payment_term' ])->middleware('permission:can create payment term');
        //             //list
        //             Route::post('list', [ PT::class, 'list_payment_term' ])->middleware('permission:can list payment term');
        //             //search
        //             Route::post('search', [ PT::class, 'search_payment_term' ])->middleware('permission:can search payment term');
        //             //edit
        //             Route::post('edit', [PT::class, 'edit_payment_term']);
        //             //view
        //             Route::post('view', [ PT::class, 'view_payment_term' ]);
        //             //delete
        //             Route::post('delete', [ PT::class, 'delete_payment_term' ]);

        //             // Trashed
        //             //init list
        //             Route::post('deleted/list', [ PT::class, 'init_list_deleted_payment_term' ]);
        //             //restore
        //             Route::post('deleted/restore', [ PT::class, 'restore_deleted_payment_term']);
        //             //delete
        //             Route::post('deleted/delete', [ PT::class, 'delete_deleted_payment_term']);
        //         });
        //     });
        // });

        /*
        //PDG
        Route::group([ 'prefix' => 'procurement' ], function(){
             Route::group([ 'prefix' => 'cp', 'middleware' => [] ],function(){
                 Route::prefix('project')->group(function(){
                         Route::post('create/project', [ P_PC::class, 'create_project' ]);
                         Route::post('fetch/project', [ P_PC::class, 'fetch_project_by_status' ]);
                         Route::post('fetch/project/user', [ P_PC::class, 'fetch_project_by_user' ]);
                         Route::post('fetch/project/ppmp', [ P_PC::class, 'fetch_project_by_ppmp_evaluation' ]);
                 });

                Route::prefix('ppmp')->group(function(){
                        Route::post('create/ppmp', [ P_EP::class, 'create_ppmp_evaluation' ]);
                });

                Route::prefix('project_history')->group(function(){
                    Route::post('create/project_history', [ P_PH::class, 'create_project_history' ]);
                    Route::post('fetch/project_history/project_id', [ P_PH::class, 'fetch_project_history_by_project_id' ]);
                });
            });
        });
        */
    });
});

Route::group(['middleware' => 'guest:api'], function () {
    Route::post('login', [LoginController::class, 'login']);
    Route::post('register', [RegisterController::class, 'register']);
    Route::post('password/email', [ForgotPasswordController::class, 'sendResetLinkEmail']);
    Route::post('password/reset', [ResetPasswordController::class, 'reset']);

    Route::post('oauth/{driver}', [OAuthController::class, 'redirect']);
    Route::get('oauth/{driver}/callback', [OAuthController::class, 'handleCallback'])->name('oauth.callback');

    Route::post('return/post', [SampleBackend::class, 'GetPost']);
});

Route::group(['prefix' => 'retrieve-generate-file-link'], function () {
    Route::get('fetch', [GenerateFileLinkController::class, 'fetch']);
    Route::get('download', [GenerateFileLinkController::class, 'download']);
});

Route::group(['prefix' => 'retrieve-generate-drive-link'], function () {
    Route::get('fetch', [GenerateDriveLinkController::class, 'fetch']);
    Route::get('download', [GenerateDriveLinkController::class, 'download']);
});

//Route::post('register/account', [ AA_C::class, 'register_new_applicant' ]);
//Route::post('login/account', [ AA_C::class, 'authenticate' ]);
Route::post('post', [PC_C::class, 'create_position']);

Route::post('post', [PC_C::class, 'create_position']);

//Route::post('register/account', [ AA_C::class, 'register_new_applicant' ]);
//Route::post('login/account', [ AA_C::class, 'authenticate' ]);
//Route::post('post', [PC_C::class, 'create_position']);


Route::post('create_exam', [AES_C::class, 'create_exam_schedule']);
Route::post('fetch_all', [AES_C::class, 'fetch_all_exam_schedule']);
Route::post('fetch_by', [AES_C::class, 'fetch_by_status_exam_schedule']);


//Backend

//Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
 //   return $request->user();
//});

    // Route::post('create_exam_interview', [AEI_C::class, 'create_exam_schedule']);
    // Route::post('fetch_all_exam_interview', [AEI_C::class, 'fetch_all_exam_schedule']);
    // Route::post('fetch_by_status_exam_interview', [AEI_C::class, 'fetch_by_status_exam_schedule']);
