<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>Document</title>
    <style>
        * {
            margin: 0;
            padding: 0;
        }

        body {
            width: 100vw;
            height: 100vh;
            padding: 20px;
            width: 100%;
            height: 100%;
        }

        @import url('https://fonts.googleapis.com/css?family=Roboto:200,300,400,600,700');

        #payslip {
            position: relative;
        }

        #nkti-logo {
            position: absolute;
            top: 0;
            left: 0;
            max-width: 64px;
            max-height: 64px;
        }

        #nkti-logo > img {
            max-width: 100%;
            max-height: 100%;
        }

        #payslip-title {
            text-align: center;
        }

        #payslip-content-header {
            text-align: center;
            margin-top: 20px;
        }

        .personal-information-title {
            float: left; 
            max-width: 15%; 
            width: 15%; 
            text-align: right;
        }

        .personal-information-text {
            float: right; 
            max-width:85%; 
            width:85%;
        }

        .personal-information-text > p {
            max-width:50%;
            width:50%; 
            padding-left: 20px;
        }

        .float-left {
            float: left;
        }

        .float-right {
            float: right;
        }

        .clear-float {
            clear: both;
        }
        table {
            width: 80%;
            table-layout: fixed;
        }
        hr {
            width: 78%;
            background-color: black;
            border: none;
        }
    </style>
</head>
<body>
    <div id="payslip">
        <div id="payslip-title">
            <div id="payslip-header">
                <h1>National Kidney and Transplant Institute</h1>
            </div>
            <div id="payslip-subtitle">
                <p>East Avenue, Diliman Quezon City 1101 Philippines</p>
            </div>
        </div>
        <div id="payslip-content">
            <div id="payslip-content-header">
                <h2>PAY SLIP</h2>
                <h2>For the Period {{$payrollPeriod}}</h2>
            </div>
            <div id="payslip-content-text">
                <div class="personal-information" style="margin-top: 20px;">
                    <div>
                        <div class="personal-information-title">
                            <p>Name:</p>
                        </div>
                        <div class="personal-information-text">
                            <p>{{$name}}</p>
                        </div>
                    </div>
                    <div style="clear: both;">
                        <div class="personal-information-title">
                            <p>Position:</p>
                        </div>
                        <div class="personal-information-text">
                            <p>{{$position}}</p>
                        </div>
                    </div>
                    <div class="clear-float" style="display:block;">
                        @if ($sector == 'public')
                            <table style="width: 100%; margin-left: 60px; text-align:left;">
                                <tbody style="width: 100%;">
                                    <tr>
                                        <td>SG</td>
                                        <td><h4>{{$salaryGrade}}</h4></td>
                                        <td>Step</td>
                                        <td><h4>{{$salaryStep}}</h4></td>
                                    </tr>
                                </tbody>
                            </table>
                        @endif
                        <table style="margin-left: 60px; text-align:left;">
                            <tbody>
                                <tr>
                                    <td>&nbsp;</td>
                                    <td>&nbsp;</td>
                                    <td>&nbsp;</td>
                                    <td>&nbsp;</td>
                                </tr>
                                <tr>
                                    <td>Salaries</td>
                                    <td></td>
                                    <td></td>
                                    <td>{{$basicPay}}</td>
                                   
                                </tr>
                                <tr>
                                    <td>PERA</td>
                                    <td></td>
                                    <td></td>
                                    <td>{{$PERA}}</td>
                                </tr>
                                <tr>
                                    <td>&nbsp;</td>
                                    <td>&nbsp;</td>
                                    <td>&nbsp;</td>
                                    <td>___________</td>
                                </tr>
                                <tr>
                                    <td>Gross</td>
                                    <td></td>
                                    <td></td>
                                    <td>{{$grossPay}}</td>
                                </tr>
                                <tr>
                                    <td>Add: Salary Adjustment</td>
                                    <td></td>
                                    <td></td>
                                    <td>-</td>
                                </tr>
                                {{-- <tr>
                                    <td>Less: LWOP</td>
                                    <td></td>
                                    <td></td>
                                    <td>-</td>
                                </tr> --}}
                                <tr>
                                    <td>&nbsp;</td>
                                    <td>&nbsp;</td>
                                    <td>&nbsp;</td>
                                    <td>___________</td>
                                </tr>
                                <tr>
                                    <td><h4>GROSS PAY</h4></td>
                                    <td></td>
                                    <td></td>
                                    <td>{{$grossPay}}</td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                    <div style="background-color:rgb(182, 182, 182); margin-left: 60px; margin-top: 20px; padding: 5px; width:77%;">
                        <h4>DEDUCTIONS:</h4>
                    </div>
                    <div class="clear-float" style="display:block;">
                        <table style="margin-left: 60px; text-align:left;">
                            <tbody>
                                <tr>
                                    <td>&nbsp;</td>
                                    <td>&nbsp;</td>
                                    <td>&nbsp;</td>
                                    <td>&nbsp;</td>
                                </tr>
                                <tr>
                                    <td>Philhealth</td>
                                    <td></td>
                                    <td></td>
                                    <td>{{$philHealth}}</td>
                                </tr>
                                <tr>
                                    <td>GSIS</td>
                                    <td></td>
                                    <td></td>
                                    <td>{{$gsis}}</td>
                                </tr>
                                <tr>
                                    <td>PAGIBIG</td>
                                    <td></td>
                                    <td></td>
                                    <td>{{$pagibig}}</td>
                                </tr>
                                <tr>
                                    <td>W-Tax</td>
                                    <td></td>
                                    <td></td>
                                    <td>{{$withholdingTax}}</td>
                                </tr>
                                {{-- <tr>
                                    <td>GSIS Conso Loan</td>
                                    <td></td>
                                    <td></td>
                                    <td>-</td>
                                </tr>
                                <tr>
                                    <td>GSIS Reg. Policy Loan</td>
                                    <td></td>
                                    <td></td>
                                    <td>-</td>
                                </tr>
                                <tr>
                                    <td>GSIS Emergency Loan</td>
                                    <td></td>
                                    <td></td>
                                    <td>-</td>
                                </tr>
                                <tr>
                                    <td>GSIS Educ Loan</td>
                                    <td></td>
                                    <td></td>
                                    <td>-</td>
                                </tr>
                                <tr>
                                    <td>GSIS MPL</td>
                                    <td></td>
                                    <td></td>
                                    <td>-</td>
                                </tr>
                                <tr>
                                    <td>GSIS Fin. Assistance Loan</td>
                                    <td></td>
                                    <td></td>
                                    <td>3,158.73</td>
                                </tr>
                                <tr>
                                    <td>HDMF MPL</td>
                                    <td></td>
                                    <td></td>
                                    <td>3,158.73</td>
                                </tr> --}}
                                <tr>
                                    <td>&nbsp;</td>
                                    <td>&nbsp;</td>
                                    <td>&nbsp;</td>
                                    <td>___________</td>
                                </tr>
                                <tr>
                                    <td><h4>TOTAL DEDUCTIONS</h4></td>
                                    <td></td>
                                    <td></td>
                                    <td><h4>{{$totalDeductions}}</h4></td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                    <div style="text-align: center; margin-top: 50px;">
                        <p style="font-style: italic;">I acknowledge receipt of cash shown as full compensation for service rendered</p>
                    </div>

                    <div style="background-color:rgb(182, 182, 182); margin-left: 60px; margin-top: 20px; padding: 5px; width:77%;">
                        <h4>LEAVE BALANCES:</h4>
                    </div>

                    <div class="clear-float" style="display:block;">
                        <table style="margin-left: 60px; text-align:left;">
                            <tr>
                                <br>
                            </tr>
                            
                        </table>
                    </div>

                    <div class="clear-float" style="display:block;">
                        @foreach(@$leave_balances as $leave_balance) 
                        <table style="margin-left: 60px; text-align:left;">
                            <tbody>
                                <tr>
                                    <td>{{$leave_balance->title}}</td>
                                    <td></td>
                                    <td></td>
                                    <td>{{$leave_balance->balance}}</td>
                                </tr>
                            </tbody>
                        </table>
                        @endforeach
                        <br>
                        <hr style="margin-left: 60px; text-align:left;">
                    </div>

                    <div class="clear-float" style="display:block;">
                        <table style="margin-left: 60px; text-align:left;">
                            <tbody>
                                <tr>
                                    <td>&nbsp;</td>
                                    <td>&nbsp;</td>
                                    <td>&nbsp;</td>
                                    <td>&nbsp;</td>
                                </tr>
                               
                                <tr>
                                    <td><h4>NET FOR THE MONTH</h4></td>
                                    <td></td>
                                    <td></td>
                                    <td><h4>{{$netPayMonth}}</h4></td>
                                </tr>
                                <tr>
                                    <td>&nbsp;</td>
                                    <td>&nbsp;</td>
                                    <td>&nbsp;</td>
                                    <td><h4>___________</h4></td>
                                </tr>
                                <tr>
                                    <td><h4>NETPAY 1-15</h4></td>
                                    <td></td>
                                    <td></td>
                                    <td><h4>{{$netPayHalf}}</h4></td>
                                </tr>
                                <tr>
                                    <td><h4>NETPAY 16-31</h4></td>
                                    <td></td>
                                    <td></td>
                                    <td><h4>{{$netPayHalf}}</h4></td>
                                </tr>
                                <tr>
                                    <td>&nbsp;</td>
                                    <td>&nbsp;</td>
                                    <td>&nbsp;</td>
                                    <td>&nbsp;</td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                    <div style="margin-left: 60px;">
                        <h4>Signature of Employee: ________________________________________</h4>
                    </div>
                
                </div>
            </div>
        </div>
      
            <div id="nkti-logo">
                <img src="https://pbs.twimg.com/profile_images/432788048758054912/pDZi6KWo_400x400.png" alt="NKTI">
            </div>
     
    </div>
    
</body>
</html>