<?php
//Procurement
use Suiterus\Pdg\Controllers\CP\ProjectController as P_PC;
use Suiterus\Pdg\Controllers\CP\EvaluationOfPpmpController as P_EP;
use Suiterus\Pdg\Controllers\CP\ProjectHistoryController as P_PH;

Route::group([ 'prefix' => 'api', 'middleware' => 'auth:api' ], function(){

    //functions
    Route::group([ 'prefix' => 'functions' ], function(){
          //PDG
          Route::group([ 'prefix' => 'procurement' ], function(){
            Route::group([ 'prefix' => 'cp', 'middleware' => [] ],function(){
                Route::prefix('project')->group(function(){
                        Route::post('create/project', [ P_PC::class, 'create_project' ]); 
                        Route::post('fetch/project', [ P_PC::class, 'fetch_project_by_status' ]);  
                        Route::post('fetch/project/user', [ P_PC::class, 'fetch_project_by_user' ]);
                        Route::post('fetch/project/ppmp', [ P_PC::class, 'fetch_project_by_ppmp_evaluation' ]);  
                });

               Route::prefix('ppmp')->group(function(){
                       Route::post('create/ppmp', [ P_EP::class, 'create_ppmp_evaluation' ]); 
               });

               Route::prefix('project_history')->group(function(){
                   Route::post('create/project_history', [ P_PH::class, 'create_project_history' ]); 
                   Route::post('fetch/project_history/project_id', [ P_PH::class, 'fetch_project_history_by_project_id' ]); 
               });
           });
       });
    });

});
