<?php

namespace Suiterus\Pdg\Controllers\CP;

use Illuminate\Database\Eloquent\ModelNotFoundException as ME;
use Suiterus\Pdg\Models\CP\Project as PRJ;
use Suiterus\Pdg\Models\CP\ProjectHistory as PRJ_H;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Carbon\Carbon;
use Validator;
use DB;

class ProjectHistoryController extends Controller
{
    public function create_project_history(Request $req)
    {
        $valid = Validator::make($req->all(), [

            'project_id'      => 'required',
            'project_content' => 'required',
            'status'         => 'required|numeric'

        ]);
        if ($valid->fails()) {
            return response()->json(
                [
                    'errors' => $valid->errors(),
                ],
                400
            );
        }
        DB::beginTransaction();
        try{

            $project_history =  PRJ_H::create([

                'project_id'            => $req->project_id,
                'project_content'       => $req->project_content,
                'status'                => $req->status

            ]);

            $project_history->save();
            DB::commit();
            return response()->json([
                'text' => 'Project History created successfully!.',
            ]);
        } catch(\Exception $e){
            DB::rollback();
            return response()->json(
                [
                    'errors' => ['Can`t create your Project History as of now. Contact the developer to fix it. Error Code : '],
                    'msg' => $e->getMessage(),
                ],
                500
            );
        }
        return json_encode($response);
    }

    public function fetch_project_history_by_project_id(Request $req)
    {
        $valid = Validator::make($req->all(), [
            'project_id' => 'required|numeric|exists:pdg_db.projects,id',
            'page_count'=> 'nullable' // for future reference
        ]);
        if ($valid->fails()) {
            return response()->json(
                [
                    'errors' => $valid->errors(),
                ],
                400
            );
        }
       
        $data = PRJ_H::where('project_id', $req->project_id)->paginate(10);

        return response()->json([
            'message' => 'Fetch successful.',
            'data' => $data,
        ]);
    }
}
