<?php

namespace Suiterus\Pdg\Controllers\CP;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Database\Eloquent\ModelNotFoundException as ME;
use Suiterus\Pdg\Models\CP\Project as PRJ;
use Suiterus\Pdg\Models\CP\ProjectAttachment as PRJ_A;
use Suiterus\Pdg\Models\CP\EvaluationOfPpmp as EP;
use Carbon\Carbon;
use Validator;
use DB;

class ProjectController extends Controller
{
    public function create_project(Request $req)
    {
        $valid = Validator::make($req->all(), [
            'project_id_name' => 'required|string',
            'project_nature' => 'required|string',
            'project_budget' => 'required|string',
            'target_date' => 'required|string',
            'procure_reason' => 'required|string',
            'recepient_id' => 'required|numeric',
            'created_by' => 'required|numeric',
            'data_file' => 'required',
            'attachment_name'=> 'required'

        ]);
        if ($valid->fails()) {
            return response()->json(
                [
                    'errors' => $valid->errors(),
                ],
                400
            );
        }
        DB::beginTransaction();
        try {
            $project = PRJ::create([
                'project_id_name' => $req->project_id_name,
                'project_nature' => $req->project_nature,
                'project_budget' => $req->project_budget,
                'target_date' => $req->target_date,
                'procure_reason' => $req->procure_reason,
                'recepient_id' => $req->recepient_id,
                'created_by' => $req->created_by,
                'status' => 1,
            ]);

            $project['created_at'] = Carbon::parse($req->selected_value_from_datepickers);
            $project->save();
            $project->id;
            $date = Carbon::parse($req->selected_value_from_datepickers);
            $req['project_id'] = $project->id;
            //UPLOAD FILE
               
            $upload = $this->submitFile((object)$req->all());
            return $upload;

            DB::commit();
            return response()->json([
                'text' => 'Project created successfully!.',
            ]);
        } catch (\Exception $e) {
            DB::rollback();
            return response()->json(
                [
                    'errors' => ['Can`t create your project as of now. Contact the developer to fix it. Error Code : '],
                    'msg' => $e->getMessage(),
                ],
                500
            );
        }
    }
    public function submitFile($req)
    {   
     DB::beginTransaction();
       try{
            foreach ($req->data_file as $key => $value) {
                $attachment_data = PRJ_A::create([
                    'project_id' => $req->project_id,
                    'attachment_name' => $req->attachment_name[$key],
                    'attachment_orig_name' => $req->data_file[$key]->getClientOriginalName(),
                    'attachment_path' => '',
                    'created_by' => $req->created_by,
                ]);
                //local path url/location
                $localPath = 'public/uploads/'.$req->project_id.'/'.$attachment_data->id.'/';
                //move/ upload file to localpath
                $uploaded_file = $req->data_file[$key]->storeAs($localPath, $req->data_file[$key]->getClientOriginalName());
                //get whole storage path
                $file_path = 'storage/uploads/'.$req->project_id.'/'.$attachment_data->id.'/'.$req->data_file[$key]->getClientOriginalName();

                $attachment_data->attachment_path = $file_path;
                $attachment_data->save();
                DB::commit();              
            }
       } catch (\Exception $e) {
            DB::rollback();
            return response()->json(
                [
                    'errors' => ['Can`t Upload File. Contact the developer to fix it. Error Code : '],
                    'msg' => $e->getMessage(),
                ],
                500
            );
        }
    }
    public function fetch_project_by_user(Request $req)
    {
        $valid = Validator::make($req->all(), [
            'user_id' => 'required|numeric|exists:mysql.users,id',
            'page_count'=> 'nullable' // for future reference
        ]);
        if ($valid->fails()) {
            return response()->json(
                [
                    'errors' => $valid->errors(),
                ],
                400
            );
        }
        $paginate = $req->page_count ?  intval($req->page_count) : 10;
       
        $data = PRJ::where('created_by', $req->user_id)->paginate($paginate);

        return response()->json([
            'message' => 'Fetch successful.',
            'data' => $data,
        ]);
    }
    public function fetch_project_by_status(Request $req)
    {
        $valid = Validator::make($req->all(), [
            'user_id' => 'required|numeric|exists:mysql.users,id', // INCASE OF AUDITTRAIL
            'status' => 'required|numeric',
            'page_count'=> 'nullable'  
        ]);
        if ($valid->fails()) {
            return response()->json(
                [
                    'errors' => $valid->errors(),
                ],
                400
            );
        }
        $paginate = $req->page_count ?  intval($req->page_count) : 10;
       

        $data = PRJ::where('status', $req->status)->paginate($paginate);
        return response()->json([
            'message' => 'Fetch successful.',
            'data' => $data,
        ]);
    }

    public function fetch_project_by_ppmp_evaluation(Request $req)
    {
        $valid = Validator::make($req->all(), [
            'status' => 'required|numeric',
            'page_count'=> 'nullable'  
        ]);
        if ($valid->fails()) {
            return response()->json(
                [
                    'errors' => $valid->errors(),
                ],
                400
            );
        }
        $paginate = $req->page_count ?  intval($req->page_count) : 10;
        $data = EP::where('status', $req->status)->paginate($paginate);
        return response()->json([
            'message' => 'Fetch successful.',
            'data' => $data,
        ]);
    }
}
