<?php

namespace Suiterus\Pdg\Controllers\CP;

use Illuminate\Database\Eloquent\ModelNotFoundException as ME;
use App\Http\Controllers\Controller;
use Suiterus\Pdg\Models\CP\EvaluationOfPpmp as EP;
use Illuminate\Http\Request;
use Carbon\Carbon;
use Validator;
use DB;

class EvaluationOfPpmpController extends Controller
{
    public function create_ppmp_evaluation(Request $req)
    {
        $valid = Validator::make($req->all(), [

            'project_id'  => 'required',
            'created_by'  => 'required|numeric',
            'status'      => 'required',
            'remarks'     => 'required|string'
        ]);
        if ($valid->fails()) {
            return response()->json(
                [
                    'errors' => $valid->errors(),
                ],
                400
            );
        }

        DB::beginTransaction();
        try {

            $evaluation_of_ppmp = EP::create([

                'project_id'    => $req->project_id,
                'created_by'    => $req->created_by,
                'status'        => $req->status,
                'remarks'       => $req->remarks
            ]);

            $evaluation_of_ppmp['created_at'] = Carbon::parse($req->selected_value_from_datepickers);
            $evaluation_of_ppmp->save();
            DB::commit();
            return response()->json([
                'text' => 'PPMP Evaluation created successfully!.',
            ]);
        } catch (\Exception $e) {
            DB::rollback();
            return response()->json(
                [
                    'errors' => ['Can`t create your PPMP Evaluation as of now. Contact the developer to fix it. Error Code : '],
                    'msg' => $e->getMessage(),
                ],
                500
            );
        }
        return json_encode($response);
     }
}
