<?php

namespace Suiterus\Hrjp\Services;

use App\Http\Classes\NotificationMessage;
use App\Notifications\JobPortalNotification;
use Illuminate\Support\Facades\Notification;

class JobPortalMailNotificationService
{
    public function sendMailNotification($email, $message, $receiverName) {
        Notification::route('mail', $email)->notify(new JobPortalNotification($message, $receiverName));
    }

    public function sendNotificationToAdmin($header, $receiverID, $senderID, $userApprover = null, $forwardId = null, $fileSignatorySigneeID = null, $applicantName = null, $customMessage = null) {
        NotificationMessage::notifyReceiver($header, $receiverID, $senderID, $userApprover, $forwardId, $fileSignatorySigneeID, $applicantName, $customMessage);
    }
}