<?php

namespace Suiterus\Hrjp\Services\ApplicantionRequirements;

use App\Traits\Logs\HasCustomLogs;
use Illuminate\Support\Facades\Auth;
use Suiterus\Adg\Models\Activity\Activity;
use Suiterus\Hrjp\Models\SupplementalDetailsUser;
use Suiterus\Hrjp\Models\SupplementalCompletionUser;
use Suiterus\Hrjp\Models\SupplementalRequirementUser;
use Suiterus\Hrjp\Services\JobPortalMailNotificationService;

class ApplicationService
{

    use HasCustomLogs;
/**
 * The function `updateRequirementStatus` updates the status, justification, and updated_at fields of a
 * specific requirement entity based on the entity name.
 *
 * @param id The ID of the requirement that needs to be updated.
 * @param applicant_req_id The applicant_req_id is the unique identifier for the applicant requirement.
 * It is used to identify the specific requirement that needs to be updated.
 * @param status The status parameter is used to update the status of a requirement. It can be a string
 * or an integer value representing the new status of the requirement.
 * @param justification The justification parameter is a string that represents the reason or
 * explanation for updating the requirement status.
 * @param entityName The entityName parameter is a string that specifies the type of requirement. It
 * can have three possible values: 'SupplementaryRequirements', 'OtherRequirements', or
 * 'CompletionAccomplishment'.
 */
    public function updateRequirementStatus ($id, $applicant_req_id, $status, $justification, $entityName)
    {
        if($entityName === 'SupplementaryRequirements'){
            $requirements = SupplementalRequirementUser::where('id', $id)
            ->where('applicant_req_id', $applicant_req_id)->first();
            $applicant = $requirements->applicantRequirementsUser()->first()->applicant()->first();
            $requirementDetails = $requirements->supplementalRequirements()->first();
        }
        elseif ($entityName === 'OtherRequirements'){
            $requirements = SupplementalDetailsUser::where('id', $id)
            ->where('applicant_req_id', $applicant_req_id)->first();
            $applicant = $requirements->applicantDetailsUser()->first()->applicant()->first();
            $requirementDetails = $requirements->supplementalDetails()->first();
        }
        elseif ($entityName === 'CompletionAccomplishment'){
            $requirements = SupplementalCompletionUser::where('id', $id)
            ->where('applicant_req_id', $applicant_req_id)->first();
            $applicant = $requirements->applicantCompletionUser()->first()->applicant()->first();
            $requirementDetails = $requirements->supplementalCompletion()->first();
        }

        $oldRequirements = clone $requirements;

        $requirements->update([
            'status' => $status,
            'justification' => $justification,
            'updated_at' => now()
        ]);

        $requirements->attributes = collect($requirements);
        $requirements->old = collect($oldRequirements);

        $statusMessage = [
            1 => 'pending',
            2 => 'approved',
            3 => 'declined'
        ];

        $fullName = $applicant->fname . ' ' . $applicant->mname . ' ' . $applicant->lname;

        $this->logCustomMessage("{$statusMessage[$status]}_applicant_requirements", $requirements, Auth::user()->name . " {$statusMessage[$status]} {$requirementDetails->title} for applicant {$fullName}", $requirements, ucfirst($statusMessage[$status]) . ' applicant requirements', new Activity());

        if ($status == 2)  {
            $customMessage = 'Approved';
        } elseif ($status == 3) {
            $customMessage = 'Disapproved';
        } else {
            $customMessage = '';
        }
        $message = 'We are informing you that we have '.$customMessage.' one of your requirement files. Please click the link below to view your application status.';
        (new JobPortalMailNotificationService)->sendMailNotification($applicant->email, $message, $fullName);
    }
    public function updateFileAttachment ($entityName, $id, $applicant_req_id, $filePath, $status  ) {

        if($entityName === 'SupplementaryRequirements'){
            SupplementalRequirementUser::where('id', $id)
            ->where('applicant_req_id', $applicant_req_id)
            ->update([
                'attachment' => $filePath,
                'status' => $status
            ]);
        }
        elseif ($entityName === 'OtherRequirements'){
            SupplementalDetailsUser::where('id', $id)
            ->where('applicant_req_id', $applicant_req_id)
            ->update([
                'attachment' => $filePath,
                'status' => $status
            ]);
        }
        elseif ($entityName === 'CompletionAccomplishment'){
            SupplementalCompletionUser::where('id', $id)
            ->where('applicant_req_id', $applicant_req_id)
            ->update([
                'attachment' => $filePath,
                'status' => $status
            ]);
        }

    }

    public function downloadFileAttachment ($entityName, $id, $applicant_req_id) {

        if($entityName === 'SupplementaryRequirements'){
            return SupplementalRequirementUser::where('id', $id)
                ->where('applicant_req_id', $applicant_req_id)
                ->first();
        }
        elseif ($entityName === 'OtherRequirements'){
            return SupplementalDetailsUser::where('id', $id)
                ->where('applicant_req_id', $applicant_req_id)
                ->first();
        }
        elseif ($entityName === 'CompletionAccomplishment'){
            return SupplementalCompletionUser::where('id', $id)
                ->where('applicant_req_id', $applicant_req_id)
                ->first();
        }

    }
}
