<?php
//Human Resources
use Suiterus\Hrjp\Controllers\ApplicationController;
use Suiterus\Hrjp\Controllers\PositionController as PC_C;
use Suiterus\Hrjp\Controllers\PositionHistoryController as PH_C;

use Suiterus\Hrjp\Controllers\ApplicantAccountController as AA_C;
use Suiterus\Hrjp\Controllers\ApplicantExamInterviewController as AEI_C;
use Suiterus\Hrjp\Controllers\ApplicantExamScheduleController as AES_C;
use Suiterus\Hrjp\Controllers\ApplicantInitialInterviewController as AII_C;

use Suiterus\Hrjp\Controllers\ApplicantRequirementsController as ARC;

use Suiterus\Hrjp\Controllers\ApplicantRequirementsScheduleController as ARS;
use Suiterus\Hrjp\Controllers\ApplicantRequireAppointmentController as ARA_C;
use Suiterus\Hrjp\Controllers\SectorController as SC;


use Suiterus\Hrjp\Controllers\Auth\RegisterController as ApplicantRegister;
use Suiterus\Hrjp\Controllers\Auth\LoginController as ApplicantLogin;
use Suiterus\Hrjp\Controllers\Auth\VerificationController as ApplicantVerification;


use Illuminate\Support\Facades\Route;

// Applicant-only functions
use Suiterus\Hrjp\Controllers\Applicant\ApplicantExamInterviewController as Applicant_I;
use Suiterus\Hrjp\Controllers\Applicant\ApplicantExamScheduleController as Applicant_E;
use Suiterus\Hrjp\Controllers\Applicant\ApplicantExtraFieldController as AEF_C;
use Suiterus\Hrjp\Controllers\Applicant\ApplicationController as AC;
use Suiterus\Hrjp\Controllers\Applicant\PositionController as ApplicantPositions;
use Suiterus\Hrjp\Controllers\Applicant\ApplicantInitialInterviewController as Applicant_AII;
use Suiterus\Hrjp\Controllers\Applicant\ApplicantRequirementsController as Applicant_ARC;
use Suiterus\Hrjp\Controllers\Applicant\ApplicantRequirementScheduleController as Applicant_ARS;

use Suiterus\Hrjp\Controllers\Applicant\ApplicantPreEmploymentFieldsController as Applicant_APEFC;
use Suiterus\Hrjp\Controllers\DownloadUploadAppointmentForm;
use Suiterus\Hrjp\Controllers\JobPostExpensesController;

Route::group(['prefix' => 'api', 'middleware' => 'auth:api'], function () {

    //functions
    Route::group(['prefix' => 'functions'], function () {
        //HRJP
        Route::group(['prefix' => 'human_resource'], function () {
            Route::group(['prefix' => 'jp', 'middleware' => []], function () {
                Route::prefix('account')->group(function () {

                    Route::post('register/account', [AC::class, 'create_application']);
                });
                Route::prefix('job')->group(function () {
                    Route::get('hiring-manager/all', [PC_C::class, 'fetch_users']);
                    Route::get('assigned_hiring_manager/all', [PC_C::class, 'fetch_hiring_manager']);
                    Route::post('create/position', [PC_C::class, 'create_position']);
                    Route::post('create_position_job_posting/position', [PC_C::class, 'create_position_job_posting'])->middleware('permission:can create position job posting');
                    Route::post('fetch_job_by_id/position', [PC_C::class, 'fetch_job_by_id']);
                    Route::post('fetch_all/position', [PC_C::class, 'fetch_all_position']);
                    Route::get('fetch_all/vacant_positions', [PC_C::class, 'fetch_vacant_positions']);
                    Route::get('fetch_all/active_positions', [PC_C::class, 'fetch_active_positions']);
                    Route::post('list/position_has_salary', [PC_C::class, 'init_position_has_salary'])->middleware('module_or_permission:Dashboard|can paginate position job posting');
                    Route::post('delete/position', [PC_C::class, 'delete_position']);
                    Route::post('update/position', [PC_C::class, 'update_position'])->middleware('permission:can update position job posting');
                    Route::post('update/slot', [PC_C::class, 'update_slot']);
                    Route::get('search/position', [PC_C::class, 'search_position']);
                    Route::get('fetch-all-data', [PC_C::class, 'position_has_salary_no_paginate'])->middleware('module_or_permission:Dashboard|can download position job posting');
                    Route::get('fetch-all/positions-with-record', [PC_C::class, 'fetch_position_with_record']);
                    Route::get('fetch-all/item-code-with-record', [PC_C::class, 'fetch_item_code_with_record']);

                    Route::post('deleted/list', [PC_C::class, 'init_list_deleted_positions']);
                    Route::post('deleted/restore', [PC_C::class, 'restore_deleted_position']);
                    Route::post('deleted/delete', [PC_C::class, 'delete_deleted_position']);

                    Route::prefix('expenses')->group(function () {
                        Route::post('fetch', [JobPostExpensesController::class , 'fetch']);
                        Route::post('create', [JobPostExpensesController::class , 'create'])->middleware('permission:can create expenses job posting');
                    });
                });

                Route::prefix('position')->group(function () {
                    Route::post('fetch_position_history', [PH_C::class, 'fetch_position_history'])->middleware('permission:can view employee salary and designation history');
                    Route::get('promoted_employees', [PH_C::class, 'fetch_promoted_employees']);
                    Route::get('dashboard_promoted_employees', [PH_C::class, 'fetch_promoted_employees_dashboard']);
                });

                Route::prefix('recruitment')->group(function () {

                    Route::get('fetch-all-data', [ApplicationController::class, 'fetch_applicants'])->middleware('module_or_permission:Dashboard|can manage job recruitment and list of all applicants');

                    Route::middleware('permission:can manage job recruitment and list of all applicants')->group(function () {
                        Route::post('step-1/list', [ApplicationController::class, 'get_step_1']);
                        Route::post('file_attachment', [ApplicationController::class, 'file_attachment_download']);
                        Route::post('approve', [ApplicationController::class, 'approve']);

                        Route::post('fetch_all/attachment', [ApplicationController::class, 'get_attachments']);
                        Route::get('fetch-all-applicants', [ApplicationController::class, 'fetch_list_all_applicants']);
                        Route::post('list_all_applicants', [ApplicationController::class, 'list_of_all_applicants']);
                        Route::post('decrement/slot', [PC_C::class, 'decrement_slot']);
                        Route::post('hire/employee', [AA_C::class, 'hiring_process']);

                        Route::post('download-file-attachment', [Applicant_ARC::class, 'download_file_attachment']);
                        Route::post('generate', [AA_C::class, 'generate_application_form']);
                    });

                });

                Route::middleware('permission:can manage job recruitment and list of all applicants')->group(function () {
                    Route::prefix('exam')->group(function () {
                        Route::post('create_exam', [AES_C::class, 'process_schedule']);
                        Route::post('fetch_all', [AES_C::class, 'fetch_all_exam_schedule']);
                        Route::post('exam_status', [AES_C::class, 'fetch_by_status_exam']);
                        Route::post('decline', [AES_C::class, 'decline']);

                        Route::post('pass', [AES_C::class, 'pass_exam']);
                        Route::post('fail', [AES_C::class, 'fail_exam']);
                        Route::post('resched_count', [AES_C::class, 'resched_count']);
                    });

                    Route::prefix('interview')->group(function () {
                        Route::post('create_interview', [AEI_C::class, 'process_schedule']);
                        Route::post('fetch_all', [AEI_C::class, 'fetch_all_exam_schedule']);
                        Route::post('exam_status', [AEI_C::class, 'fetch_by_status_exam']);
                        Route::post('decline', [AEI_C::class, 'decline']);

                        Route::post('pass', [AEI_C::class, 'pass_exam']);
                        Route::post('fail', [AEI_C::class, 'fail_exam']);
                    });

                    Route::prefix('initial_interview')->group(function () {
                        Route::get('fetch_initial_interview', [AII_C::class, 'fetch_initial_interview']);
                        Route::post('create_initial_interview_schedule', [AII_C::class, 'process_schedule']);
                        Route::post('pass_initial_interview', [AII_C::class, 'pass_initial_interview']);
                        Route::post('fail_initial_interview', [AII_C::class, 'fail_initial_interview']);
                        Route::post('fetch_by_status_initial', [AII_C::class, 'fetch_by_status_initial']);
                        Route::post('decline', [AII_C::class, 'decline']);
                        Route::post('fetch_positions_status', [AII_C::class, 'fetch_positions_status']);
                        Route::post('update_position', [AII_C::class, 'update_position']);
                        Route::post('fetch_choice', [AII_C::class, 'fetch_choice']);
                    });

                    Route::prefix('Applicant_Requirements')->group(function () {
                        Route::get('fetch_requirements', [ARC::class, 'fetch_requirements']);
                        Route::get('fetch_accomplishment', [ARC::class, 'fetch_accomplishment']);
                        Route::get('fetch_details', [ARC::class, 'fetch_details']);
                        Route::get('fetch_initial_requirements', [ARC::class, 'fetch_initial_requirements']);
                        Route::post('create_request', [ARC::class, 'create_request']);
                        Route::post('fetch_applicant_req', [ARC::class, 'fetch_applicant_req']);

                        Route::post('approve-disapprove-requirement', [ARC::class, 'approve_disapprove_requirement']);
                    });

                    Route::prefix('requirements_schedule')->group(function () {
                        Route::post('create_requirement_schedule', [ARS::class, 'create_requirement_schedule']);
                        Route::post('fetch_requirements_schedule', [ARS::class, 'fetch_requirements_schedule']);
                        Route::post('complete_initial_requirements', [ARS::class, 'complete_initial_requirements']);
                    });

                    Route::prefix('appointment_schedule')->group(function () {
                        Route::post('create_appointment_schedule', [ARA_C::class, 'create_appointment_schedule']);
                        Route::post('fetch_appointment_schedule', [ARA_C::class, 'fetch_appointment_schedule']);
                    });

                    Route::prefix('appointment_form')->group(function () {
                        Route::post('upload-form', [DownloadUploadAppointmentForm::class, 'uploadAppointmentForm']);
                        Route::post('download-form', [DownloadUploadAppointmentForm::class, 'downloadAppointmentForm']);
                    });
                });
            });
        });
    });
});

Route::group(['prefix' => 'api'], function () {
    Route::prefix('applicant')->group(function () {

        // Logged in Applicants
        Route::group(['middleware' => 'auth:applicant'], function () {
            Route::get('user', [AA_C::class, 'applicant']);
            Route::post('logout', [ApplicantLogin::class, 'logout']);
            Route::post('step/current', [AC::class, 'current_step']);
            Route::post('step/next', [AC::class, 'increment_step']);
            Route::post('information/create', [AEF_C::class, 'create']);
            Route::post('create/files', [AEF_C::class, 'createFiles']);
            Route::post('create/files/requirement', [AEF_C::class, 'setRequirementFiles']);
            Route::get('position', [AC::class, 'position']);
            Route::get('details', [AEF_C::class, 'getRecord']);
            Route::get('requirements', [AEF_C::class, 'getRequirement']);

            Route::get('exam/schedule', [Applicant_E::class, 'fetch_exam_schedule']);
            Route::get('exam/status', [Applicant_E::class, 'fetch_exam_status']);
            Route::post('reschedule', [Applicant_E::class, 'request_reschedule']);
            Route::post('update/status', [Applicant_E::class, 'status_reschedule']);
            Route::post('fetch_resched_count', [Applicant_E::class, 'fetch_resched_count']);

            Route::get('interview/status', [Applicant_I::class, 'fetch_interview_status']);
            Route::get('interview/schedule', [Applicant_I::class, 'fetch_interview_schedule']);
            Route::post('interview/reschedule', [Applicant_I::class, 'request_reschedule']);
            Route::post('interview/update/status', [Applicant_I::class, 'status_reschedule']);
            Route::post('fetch_exam_resched_count', [Applicant_I::class, 'fetch_exam_resched_count']);

            Route::get('fetch_initial_interview_schedule', [Applicant_AII::class, 'fetch_initial_interview_schedule']);
            Route::get('fetch_position', [Applicant_AII::class, 'fetch_position']);
            Route::get('fetch_initial_interview_status', [Applicant_AII::class, 'fetch_initial_interview_status']);
            Route::post('request_initial_interview_reschedule', [Applicant_AII::class, 'request_initial_interview_reschedule']);
            Route::post('initial_interview/update/status', [Applicant_AII::class, 'status_reschedule']);
            Route::post('initial_interview/decline_position', [Applicant_AII::class, 'decline_position']);
            Route::post('fetch_initial_resched_count', [Applicant_AII::class, 'fetch_initial_resched_count']);


            Route::post('fetch_applicant_request', [Applicant_ARC::class, 'fetch_applicant_request']);
            Route::post('get_applicant_req', [Applicant_ARC::class, 'get_applicant_req']);
            Route::post('increment_step_require', [Applicant_ARC::class, 'increment_step_require']);
            Route::post('upload-file-attachment', [Applicant_ARC::class, 'upload_file_attachment']);
            Route::post('download-file-attachment', [Applicant_ARC::class, 'download_file_attachment']);

            Route::post('fetch_requirement_status', [Applicant_ARS::class, 'fetch_requirement_status']);
            Route::post('update_acknowledge_requirements', [Applicant_ARS::class, 'update_acknowledge_requirements']);

            Route::post('fetch_appointment_status', [Applicant_ARS::class, 'fetch_appointment_status']);

            Route::post('pre-employment/fetching_pre_employment', [Applicant_APEFC::class, 'fetching_pre_employment']);


            Route::post('download-form-applicant', [DownloadUploadAppointmentForm::class, 'downloadAppointmentForm']);
            Route::post('fetch-appointment-form', [DownloadUploadAppointmentForm::class, 'fetchAppointmentForm']);
        });

        // Guests - Login and Register
        Route::group(['middleware' => 'guest:applicant'], function () {
            Route::post('login', [ApplicantLogin::class, 'login']);
            Route::post('register', [ApplicantRegister::class, 'register']);
            Route::post('create/application', [AC::class, 'create_application']);
            Route::post('pre-employment/create_pre_employment', [Applicant_APEFC::class, 'create_pre_employment']);
        });

        Route::group(['prefix' => 'sector'], function () {
            Route::get('fetch_sector_type', [SC::class, 'fetch_sector_type']);
        });

        Route::group(['prefix' => 'positions'], function () {
            Route::post('jobs', [ApplicantPositions::class, 'fetch_positions']);
            Route::get('all', [ApplicantPositions::class, 'positions']);
            Route::post('fetch-all-jobs', [ApplicantPositions::class, 'fetch_all_positions']);
            Route::get('show-job', [ApplicantPositions::class, 'job_details']);
        });
    });
});
