<?php
namespace Suiterus\Hrjp\Request;

use Illuminate\Support\Facades\Auth;
use Suiterus\Hrjp\Models\AppointmentForm;
use Illuminate\Foundation\Http\FormRequest;

class DownloadAppointmentFormRequest extends FormRequest {


    public function authorize(): bool
    {
        $appointmentForm = AppointmentForm::where('id', $this->id)->first();

        if (!$appointmentForm) {
            return false;
        }

        return $appointmentForm->applicant_id == Auth::id();
    }

    public function rules(): array
    {
        return [
            'id'  =>  'required|exists:' . env('HRJP_DB_CONNECTION') . '.appointment_forms,id'
        ];
    }

}
