<?php

namespace Suiterus\Hrjp\Notifications;

use Carbon\Carbon;
use Illuminate\Auth\Notifications\VerifyEmail;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Support\Facades\URL;

class VerifyApplicantEmail extends VerifyEmail
{
    /**
     * Get the verification URL for the given notifiable.
     *
     * @param  mixed  $notifiable
     * @return string
     */
    protected function verificationUrl($notifiable)
    {
        $appUrl = config('app.client_url', config('app.url'));

        $url = URL::temporarySignedRoute(
            'applicant.verify', Carbon::now()->addMinutes(60), ['applicant' => $notifiable->id]
        );

        return str_replace(url('/api'), $appUrl, $url);
    }
}
