<?php

namespace Suiterus\Hrjp\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

use Suiterus\Hrjp\Models\ApplicantRequirements;
use Suiterus\Hrjp\Models\SupplementalRequirements;


class SupplementalRequirementUser extends Model
{
    use HasFactory, softDeletes;
    protected $connection = 'hrjp_db';
    protected $fillable = [
        'applicant_req_id',
        'supplemental_req_id',
        'attachment',
        'status',
        'justification',
        'created_by',
        'created_at',
        'updated_by',
        'updated_at',
        'deleted_at'
    ];

    public function applicantRequirementsUser(){
        return $this->belongsTo(ApplicantRequirements::class, 'applicant_req_id', 'id');
    }

    public function supplementalRequirements(){
        return $this->belongsTo(SupplementalRequirements::class, 'supplemental_req_id', 'id');
    } 

}
