<?php

namespace Suiterus\Hrjp\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

use Suiterus\Hrjp\Models\ApplicantRequirements;
use Suiterus\Hrjp\Models\SupplementalDetails;


class SupplementalDetailsUser extends Model
{
    use HasFactory, softDeletes;
    protected $connection = 'hrjp_db';
    protected $fillable = [
        'applicant_req_id',
        'supplemental_detail_id',
        'attachment',
        'status',
        'justification',
        'created_by',
        'created_at',
        'updated_by',
        'updated_at',
        'deleted_at'
    ];

    public function applicantDetailsUser(){
        return $this->belongsTo(ApplicantRequirements::class, 'applicant_req_id', 'id');
    }

    public function supplementalDetails(){
        return $this->belongsTo(SupplementalDetails::class, 'supplemental_detail_id', 'id');
    } 

}
