<?php

namespace Suiterus\Hrjp\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

use Suiterus\Hrjp\Models\SupplementalDetailsUser;

class SupplementalDetails extends Model
{
    use HasFactory, softDeletes;
    protected $connection = 'hrjp_db';
    protected $fillable = [
        'title',
        'status',
        'additional_info',
        'purpose',
        'created_by',
        'created_at',
        'updated_by',
        'updated_at',
        'deleted_at'
    ];

    protected $appends = [
        'full_title'
    ];

    public function getFullTitleAttribute() {
        $additional_info = $this->additional_info == '' ? '' : ' ' . $this->additional_info . '';
        return $this->title . $additional_info;
    }

    public function supplementalDetails(){
        return $this->hasMany(SupplementalDetailsUser::class, 'supplemental_detail_id', 'id');
    } 
}
