<?php

namespace Suiterus\Hrjp\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Model;
use Suiterus\Hrjp\Models\Position;
use App\Models\User;
use Suiterus\Adg\Models\PDS\PDSPerPosition;

class Position_history extends Model
{
    use HasFactory, SoftDeletes;
    
    protected $connection = 'hrjp_db';
    
    protected $fillable = [
        
        'user_id',
        'item_code_id',
        'position_id',
        'appointment_date',
        'date_of_effectivity',
        'status',
        'position_status',
        'employment_status',
        'created_by',
        'updated_by',
        
    ];

    protected $appends = [
        'formatted_appointment_date',
        'formatted_date_of_effectivity'
    ];

    protected $with = [
        'user',
        'position',
        'pdsPerPosition',
        'itemCode'
    ];

    public function __construct(array $attributes = []){
        $this->table = env('HRJP_DB_DATABASE').'.position_histories';
        $this->connection = env('HRJP_DB_CONNECTION');
        parent::__construct($attributes);
    }

    public function user(){
        return $this->belongsTo(User::class, 'user_id', 'id');
    }

    public function position(){
        return $this->belongsTo(Position::class, 'position_id', 'id');
    }

    public function pdsPerPosition(){
        return $this->hasMany(PDSPerPosition::class, 'position_history_id', 'id' );
    }

    public function itemCode(){
        return $this->belongsTo(ItemCode::class, 'item_code_id', 'id');
    }

    public function getFormattedAppointmentDateAttribute(){
        return date("F d, Y", strtotime($this->appointment_date));
    }

    public function getFormattedDateOfEffectivityAttribute(){
        return date("F d, Y", strtotime($this->date_of_effectivity));
    }

}
