<?php

namespace Suiterus\Hrjp\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Suiterus\Hrjp\Models\Position;
use Suiterus\Adg\Models\SM\SalaryStandardization;
use Suiterus\Adg\Models\SM\SalaryGrade;
use Suiterus\Adg\Models\SM\EmployeeType;
use Suiterus\Hrjp\Models\ItemCode;
use App\Models\User;

use function PHPUnit\Framework\isEmpty;

class Position_has_salary extends Model
{
    use HasFactory, SoftDeletes;
    protected $connection = 'hrjp_db';
    protected $table = 'position_has_salaries';
    protected $fillable = [

        'item_code_id',
        'position_id',
        'hiring_manager',
        'description',
        'education',
        'training',
        'experience',
        'eligibility',
        'place_of_assignment',
        'salary',
        'slots',
        'post_status',
        'post_start',
        'post_due',
        'employee_type',
        'show_salary',
        'created_by',
        'updated_by'
        
    ];

    protected $with = [
        'position',
        'itemCodes',
    ];

    public function __construct(array $attributes = [])
    {
        $this->table = env('HRJP_DB_DATABASE') . '.position_has_salaries';
        parent::__construct($attributes);
    }

    public function position() {
        return $this->belongsTo(Position::class, 'position_id', 'id');
    }
    
    public function employeeType(){
        return $this->belongsTo(EmployeeType::class, 'employee_type', 'id');
    }

    public function hiringManager(){
        return $this->belongsTo(User::class, 'hiring_manager', 'id');
    }

    public function itemCodes(){
        return $this->belongsTo(ItemCode::class, 'item_code_id', 'id');
    }

    public function getHiringManagerAttribute($value) {
        $data = User::without('storage','roles','permissions','employeeMetaInfo')->where('id', $value)->select('name','id')->first();
        return $data;
    }

    public function salaryStandardization() {
        return $this->hasOne(SalaryStandardization::class, 'employee_type_id', 'employee_type')->where('active_tranche', 1);
    }

    public function getSalaryAttribute($value){
        $emp_type = $this->salaryStandardization;
        $active = 1;

        if($emp_type){
            $data = SalaryGrade::whereHas('salary_standardization', function($query) use($emp_type, $active){
                $query->where('id', $emp_type->id)->where('active_tranche', $active);
            })->where('step', 1)->where('salary_grade', $value)->select('ss_id', 'salary_grade', 'value', 'id')->first();
        }else{
            $data = SalaryGrade::whereHas('salary_standardization', function($query) use($emp_type, $active){
                $query->whereHas('employeeType', function($query) {
                    $query->where('title','Regular');
                })->where('active_tranche', $active);
            })->where('step', 1)->where('salary_grade', $value)->select('ss_id', 'salary_grade', 'value', 'id')->first();
        }
        
        return $data==null ? $value : $data;
    }

    public function expenses()
    {
        return $this->hasMany(JobPostExpenses::class, 'phs_id', 'id');
    }
}