<?php

namespace Suiterus\Hrjp\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Suiterus\Adg\Models\EMI\EmployeeMetaInfo;
use Suiterus\Adg\Models\Mentorship\Mentorship;
use Illuminate\Database\Eloquent\Factories\HasFactory;


class Position extends Model
{
    use HasFactory, SoftDeletes;
    protected $connection = 'hrjp_db';
    protected $fillable = [

        'title',
        'group_id',
        'created_by',
        'updated_by'

    ];

    public function __construct(array $attributes = []) {
        $this->table = env('HRJP_DB_DATABASE') . '.positions';
        parent::__construct($attributes);
    }

    public function mentorship(){
        return $this->morphOne(Mentorship::class, 'entity');
    }


    public function positionHasSalary(){
        return $this->hasMany('Suiterus\Hrjp\Models\Position_has_salary');
    }

    public function employeeMetaInfo(){
        return $this->hasOne('Suiterus\Adg\Models\EMI\EmployeeMetaInfo');
    }

    public function positionHistory(){
        return $this->hasMany('Suiterus\Hrjp\Models\Position_history');
    }

    public function rosterGroup(){
        return $this->belongsTo('Suiterus\Adg\Models\SM\RosterGroup','group_id', 'id');
    }

    public function initialInterview(){
        return $this->hasMany('Suiterus\Hrjp\Models\ApplicantInitialInterview', 'applicant_id', 'id');
    }

    public function requirementSched(){
        return $this->hasMany('Suiterus\Hrjp\Models\ApplicantRequirementsSchedule', 'applicant_id', 'id');
    }
    public function Option(){
        return $this->hasMany('Suiterus\Hrjp\Models\ApplicantPositionOption', 'position_option', 'id');
    }

    public Function itemCodes(){
        return $this->hasMany('Suiterus\Hrjp\Models\ItemCode', 'position_id', 'id');
    }
}
