<?php

namespace Suiterus\Hrjp\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Suiterus\Adg\Models\Promotion\PromotionApplication;
use Suiterus\Hrjp\Models\Position_has_salary;

class JobPostExpenses extends Model
{
    use HasFactory, SoftDeletes;
    protected $fillable = [
        'phs_id',
        'label',
        'amount',
        'type',
        'created_by'
    ];

    public function __construct(array $attributes = [])
    {
        $this->table = env('HRJP_DB_DATABASE') . '.job_post_expenses';
        parent::__construct($attributes);
    }

    public function phs()
    {
        return $this->belongsTo(Position_has_salary::class, 'phs_id', 'id');
    }
}