<?php

namespace Suiterus\Hrjp\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Suiterus\Adg\Models\EMI\EmployeeMetaInfo;
use Suiterus\Hrjp\Models\Position;
use Suiterus\Hrjp\Models\Position_has_salary;

class ItemCode extends Model
{
    use HasFactory, SoftDeletes;
    protected $connection = 'hrjp_db';
    protected $fillable = [

        'item_code',
        'position_id',
        'description',
        'status',

    ];

    protected $with = [
        'position'
    ];
    
    public function __construct(array $attributes = [])
    {
        $this->table = env('HRJP_DB_DATABASE') . '.item_codes';
        parent::__construct($attributes);
    }

    public function position()
    {
        return $this->belongsTo(Position::class, 'position_id', 'id');
    }

    public function positionHasSalary()
    {
        return $this->belongsTo(Position_has_salary::class, 'id', 'item_code_id');
    }

    public function employeeMetaInfo(){
        return $this->hasOne(EmployeeMetaInfo::class, 'item_code_id', 'id');
    }
}