<?php

namespace Suiterus\Hrjp\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class AppointmentForm extends Model
{
    use HasFactory;
    protected $connection = 'hrjp_db';
    protected $fillable = [
        'applicant_id',
        'created_by',
    ];
    
    protected $with = [
        'files'
    ];
    
    public function applicant(){
        return $this->belongsTo('Suiterus\Hrjp\Models\Applicant_account', 'applicant_id', 'id');
    } 

    public function files(){
        return $this->hasMany(AppointmentFormFiles::class, 'appointment_form_id', 'id');
    }
}
