<?php

namespace Suiterus\Hrjp\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Application extends Model
{
    use HasFactory, SoftDeletes;
    protected $connection = 'hrjp_db';
    protected $fillable = [
        'applicant_id',
        'status',
        'position_id',
        'old_position_id',
        'step',
        'created_by',
        'updated_by',
        'phs_id'
    ];

   
   

    public function ApplicantAccount(){
        return $this->belongsTo('Suiterus\Hrjp\Models\Applicant_account', 'applicant_id');
    }
    public function position(){
        return $this->belongsTo('Suiterus\Hrjp\Models\Position', 'position_id');
    }
    public function phs(){
        return $this->belongsTo('Suiterus\Hrjp\Models\Position_has_salary', 'phs_id');
    }

    public function requirementsSchedule(){
        return $this->hasMany('Suiterus\Hrjp\Models\ApplicantRequirementsSchedule', 'applicant_id', 'id');
    } 

    public function initialInterview(){
        return $this->hasMany('Suiterus\Hrjp\Models\ApplicantInitialInterview', 'applicant_id', 'id');
    } 

    public function applicantRequirements(){
        return $this->hasMany('Suiterus\Hrjp\Models\ApplicantRequirements', 'applicant_id', 'id');
    } 
}
