<?php

namespace Suiterus\Hrjp\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Suiterus\Hrjp\Models\Applicant_account;


class Applicant_exam_schedule extends Model
{
    use HasFactory, softDeletes;
    protected $connection = 'hrjp_db';
    protected $fillable = [
        'applicant_id',
        'schedule',
        'proctor',
        'justification',
        'zoomlink',
        'description',
        'status',
        'created_by',
        'created_at',
        'updated_by',
        'updated_at',
        'deleted_at'
    ];

    public function applicant(){
        return $this->belongsTo(Applicant_account::class, 'applicant_id', 'id');
    }
    public function examReschedule(){
        return $this->hasMany('Suiterus\Hrjp\Models\ApplicantExamReschedule', 'exam_schedule', 'id');
    }

    //Mutators and Accessors
    public function getScheduleAttribute($value){
        $date=date_create($value);
        return date_format($date,"F d, Y h:i a");
    }

    public function getUpdatedAtAttribute($value){
        $date = date_create($value);
        return date_format($date,"F d, Y");
    }
}
