<?php

namespace Suiterus\Hrjp\Models;

use App\Notifications\VerifyEmail;
use App\Notifications\ResetPassword;
use Tymon\JWTAuth\Contracts\JWTSubject;
use Illuminate\Notifications\Notifiable;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Contracts\Auth\MustVerifyEmail;
use Suiterus\Hrjp\Models\ApplicantExtraField as AEF;
use Suiterus\Hrjp\Notifications\VerifyApplicantEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Suiterus\Hrjp\Models\ApplicantPreEmploymentFields;
use Illuminate\Foundation\Auth\User as Authenticatable;

class Applicant_account extends Authenticatable implements JWTSubject
{
    use HasFactory,
        SoftDeletes,
        Notifiable;

    protected $guard = 'applicant';

    protected $connection = 'hrjp_db';

    protected $fillable = [
        'email',
        'fname',
        'mname',
        'lname',
        'password',
        'wp_password',
        'email_verified_at'
    ];

    protected $hidden = [
        'password',
        'wp_password',
        'remember_token'
    ];

    protected $casts = [
        'email_verified_at' => 'datetime'
    ];

    /**
     * @return int
     */
    public function getJWTIdentifier()
    {
        return $this->getKey();
    }

    /**
     * @return array
     */
    public function getJWTCustomClaims()
    {
        return [];
    }

    public function sendPasswordResetNotification($token)
    {
        $this->notify(new ResetPassword($token));
    }

    public function sendEmailVerificationNotification()
    {
        $this->notify(new VerifyApplicantEmail);
    }

    // Relationships

    public function application() {
        return $this->hasOne('Suiterus\Hrjp\Models\Application', 'applicant_id', 'id');
    }
    public function examSchedule(){
        return $this->hasMany('Suiterus\Hrjp\Models\Applicant_exam_schedule', 'applicant_id', 'id');
    }
    public function examReschedule(){
        return $this->hasMany('Suiterus\Hrjp\Models\ApplicantExamReschedule', 'applicant_id', 'id');
    }
    public function interviewSchedule(){
        return $this->hasMany('Suiterus\Hrjp\Models\Applicant_exam_interview', 'applicant_id', 'id');
    }
    public function initialInterview(){
        return $this->hasMany('Suiterus\Hrjp\Models\ApplicantInitialInterview', 'applicant_id', 'id');
    }

    public function requirementsSchedule(){
        return $this->hasMany('Suiterus\Hrjp\Models\ApplicantRequirementsSchedule', 'applicant_id', 'id');
    }
    public function appointmentSchedule(){
        return $this->hasMany('Suiterus\Hrjp\Models\ApplicantRequireAppointment', 'applicant_id', 'id');
    }
    public function positionOption(){
        return $this->hasMany('Suiterus\Hrjp\Models\ApplicantPositionOption', 'applicant_id', 'id');
    }
    public function preEmployment(){
        return $this->hasMany('Suiterus\Hrjp\Models\ApplicantPreEmploymentFields', 'applicant_id', 'id');
    }

    public function applicantRequirements(){
        return $this->hasMany(ApplicantRequirements::class, 'applicant_id', 'id');
    }

    public function appointmentForm(){
        return $this->hasOne(AppointmentForm::class, 'applicant_id', 'id');
    }

    public function extraField(){
        return $this->hasMany(AEF::class, 'applicant_id', 'id');
    }
    /*
        For PDS
    */
    public function personalInformation(){
        return $this->hasOne(AEF::class, 'applicant_id', 'id')->where('table_name', 'personal_information');
    }

    public function pdsChoices(){
        return $this->hasOne(AEF::class, 'applicant_id', 'id')->where('table_name', 'pds_choices');
    }

    public function otherInformation(){
        return $this->hasOne(AEF::class, 'applicant_id', 'id')->where('table_name', 'other_information');
    }

    public function permanentAddress(){
        return $this->hasOne(AEF::class, 'applicant_id', 'id')->where('table_name', 'permanent_address');
    }

    public function residentialAddress(){
        return $this->hasOne(AEF::class, 'applicant_id', 'id')->where('table_name', 'residential_address');
    }

    public function spouse(){
        return $this->hasOne(AEF::class, 'applicant_id', 'id')->where('table_name', 'spouse');
    }

    public function children(){
        return $this->hasMany(AEF::class, 'applicant_id', 'id')->where('table_name', 'children');
    }

    public function father(){
        return $this->hasOne(AEF::class, 'applicant_id', 'id')->where('table_name', 'father');
    }

    public function maidenName(){
        return $this->hasOne(AEF::class, 'applicant_id', 'id')->where('table_name', 'maiden_name');
    }

    public function elementary(){
        return $this->hasMany(AEF::class, 'applicant_id', 'id')->where('table_name', 'elementary');
    }

    public function secondary(){
        return $this->hasMany(AEF::class, 'applicant_id', 'id')->where('table_name', 'secondary');
    }

    public function vocational(){
        return $this->hasMany(AEF::class, 'applicant_id', 'id')->where('table_name', 'vocational');
    }

    public function college(){
        return $this->hasMany(AEF::class, 'applicant_id', 'id')->where('table_name', 'college');
    }

    public function graduate(){
        return $this->hasMany(AEF::class, 'applicant_id', 'id')->where('table_name', 'graduate');
    }

    public function civilService(){
        return $this->hasMany(AEF::class, 'applicant_id', 'id')->where('table_name', 'civil_services');
    }

    public function workExperience(){
        return $this->hasMany(AEF::class, 'applicant_id', 'id')->where('table_name', 'work_experience');
    }

    public function voluntaryWork(){
        return $this->hasMany(AEF::class, 'applicant_id', 'id')->where('table_name', 'voluntary_work');
    }

    public function learningDevelopment(){
        return $this->hasMany(AEF::class, 'applicant_id', 'id')->where('table_name', 'learning_development');
    }

    public function skillHobby(){
        return $this->hasMany(AEF::class, 'applicant_id', 'id')->where('table_name', 'skills_hobbies');
    }

    public function choice(){
        return $this->hasOne(AEF::class, 'applicant_id', 'id')->where('table_name', 'choices');
    }

    public function reference(){
        return $this->hasMany(AEF::class, 'applicant_id', 'id')->where('table_name', 'reference');
    }

    public function governmentIssuedId(){
        return $this->hasMany(AEF::class, 'applicant_id', 'id')->where('table_name', 'government_id');
    }

    public function fileAttachment(){
        return $this->hasOne(AEF::class, 'applicant_id', 'id')->where('table_name', 'file_attachments');
    }

    // Mutators and Accessors
    public function setLnameAttribute($value)
    {
        $this->attributes['lname'] = ucwords($value);
    }
    public function setMnameAttribute($value)
    {
        $this->attributes['mname'] = strtoupper($value);
    }
    public function setFnameAttribute($value)
    {
        $this->attributes['fname'] = ucwords($value);
    }
}
