<?php

namespace Suiterus\Hrjp\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

use Suiterus\Hrjp\Models\Applicant_account;
use Suiterus\Hrjp\Models\CompletionAccomplishment;
use Suiterus\Hrjp\Models\SupplementalDetails;
use Suiterus\Hrjp\Models\SupplementalRequirements;
use Suiterus\Hrjp\Models\SupplementalCompletionUser;
use Suiterus\Hrjp\Models\SupplementalDetailsUser;
use Suiterus\Hrjp\Models\SupplementalRequirementUser;

class ApplicantRequirements extends Model
{
    use HasFactory, softDeletes;
    protected $connection = 'hrjp_db';
    protected $fillable = [
        'applicant_id',
        'message',
        'status',
        'created_by',
        'created_at',
        'updated_by',
        'updated_at',
        'deleted_at'
    ];

    public function applicant(){
        return $this->belongsTo(Applicant_account::class, 'applicant_id', 'id');
    }
    public function completionAccomplishment(){
        return $this->belongsTo(CompletionAccomplishment::class, 'applicant_id', 'id');
    } 
    public function supplementalDetails(){
        return $this->belongsTo(SupplementalDetails::class, 'applicant_id', 'id');
    } 
    public function supplementalRequirements(){
        return $this->belongsTo(SupplementalRequirements::class, 'applicant_id', 'id');
    } 

    public function applicantCompletionUser(){
        return $this->hasMany(SupplementalCompletionUser::class, 'applicant_req_id', 'id');
    }

    public function applicantDetailsUser(){
        return $this->hasMany(SupplementalDetailsUser::class, 'applicant_req_id', 'id');
    }
    public function applicantRequirementsUser(){
        return $this->hasMany(SupplementalRequirementUser::class, 'applicant_req_id', 'id');
    } 
    

}
