<?php

namespace Suiterus\Hrjp\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Suiterus\Hrjp\Models\Applicant_account;
use Suiterus\Hrjp\Models\Application;

class ApplicantRequireAppointment extends Model
{
    use HasFactory, SoftDeletes;

    protected $connection = 'hrjp_db';
    protected $fillable = [
        'applicant_id',
        'schedule',
        'personnel',
        'office',
        'status',
        'created_by',
        'created_at',
        'updated_by',
        'deleted_at'
    ];

    public function applicant(){
        return $this->belongsTo(Applicant_account::class, 'applicant_id', 'id');
    }

    public function Application(){
        return $this->belongsTo(Application::class, 'applicant_id', 'id');
    }


    //Mutators and Accessors
    public function getScheduleAttribute($value){
        $date=date_create($value);
        return date_format($date,"F d, Y h:i a");
    }

    public function getUpdatedAtAttribute($value){
        $date = date_create($value);
        return date_format($date,"F d, Y");
    }


}
