<?php


namespace Suiterus\Hrjp\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ApplicantPreEmploymentFieldsColumn extends Model
{
    use HasFactory, softDeletes;
    protected $connection = 'hrjp_db';
    protected $table = 'applicant_pre_employment_info';
    protected $fillable = [
        'pre_employment_field',
        'field_name',
        'field_value',
        'field_type',
        'field_status',
        'created_by',
        'created_at',
        'updated_by',
        'updated_at',
        'deleted_at'
    ];

    protected $appends = [
        'formatted_date_of_application'
    ];

    public function preEmploymentField(){
        return $this->belongsTo('Suiterus\Hrjp\Models\ApplicantPreEmploymentFields', 'pre_employment_field', 'id');
    } 

    public function getFormattedDateOfApplicationAttribute(){
        $dateOfApplication = $this->where([
            ['id', $this->id], ['field_name', 'date_of_application']
        ])->first();

        return $dateOfApplication ? date("F d, Y", strtotime($dateOfApplication->field_value)) : date("F d, Y", strtotime($this->field_value));
    }
}
