<?php

namespace Suiterus\Hrjp\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ApplicantPreEmploymentFields extends Model
{
    use HasFactory, softDeletes;
    protected $connection = 'hrjp_db';
    protected $table = 'applicant_pre_employment_fields';
    protected $fillable = [
        'applicant_id',
        'table_name',
        'created_by',
        'created_at',
        'updated_by',
        'updated_at',
        'deleted_at'
    ];
    protected $with = [
        'preEmploymentColumn'
    ];

    public function applicant(){
        return $this->belongsTo('Suiterus\Hrjp\Models\Applicant_account', 'applicant_id', 'id');
    } 

    public function preEmploymentColumn(){
        return $this->hasMany('Suiterus\Hrjp\Models\ApplicantPreEmploymentFieldsColumn', 'pre_employment_field', 'id');
    } 

}
