<?php

namespace Suiterus\Hrjp\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ApplicantExtraFieldHasMoreInfo extends Model
{
    use HasFactory, softDeletes;
    protected $connection = 'hrjp_db';
    protected $fillable = [
        'applicant_extra_field',
        'field_name',
        'field_value',
        'field_type',
        'field_status',
        'created_by',
        'created_at',
        'updated_by',
        'updated_at',
        'deleted_at'
    ];
    public function extraField(){
        return $this->belongsTo('Suiterus\Hrjp\Models\ApplicantExtraField', 'applicant_extra_field', 'id');
    } 
}
