<?php

namespace Suiterus\Hrjp\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
class ApplicantExtraField extends Model
{
    use HasFactory, softDeletes;
    protected $connection = 'hrjp_db';
    protected $fillable = [
        'applicant_id',
        'table_name',
        'created_by',
        'created_at',
        'updated_by',
        'updated_at',
        'deleted_at'
    ];
    protected $with = [
        'extraFieldColumn'
    ];

    public function applicant(){
        return $this->belongsTo('Suiterus\Hrjp\Models\Applicant_account', 'applicant_id', 'id');
    } 
    public function extraFieldColumn(){
        return $this->hasMany('Suiterus\Hrjp\Models\ApplicantExtraFieldHasMoreInfo', 'applicant_extra_field', 'id');
    } 
}
