<?php

namespace Suiterus\Hrjp\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Suiterus\Hrjp\Models\Applicant_account;

class ApplicantExamReschedule extends Model
{
    use HasFactory, softDeletes;
    protected $connection = 'hrjp_db';
    protected $fillable = [
        'applicant_id',
        'exam_schedule',
        'reason',
        'status',
        'created_by',
        'created_at',
        'updated_by',
        'updated_at',
        'deleted_at'
    ];

    public function applicant(){
        return $this->belongsTo(Applicant_account::class, 'applicant_id', 'id');
    }
}
