<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddExpensesTableInPhs extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection(env('HRJP_DB_CONNECTION'))->create('job_post_expenses', function(Blueprint $table){
            $table->id();
            $table->unsignedBigInteger('phs_id');
            $table->string('label');
            $table->decimal('amount');
            $table->integer('type')->comment('1 = Direct, 2 = Indirect');
            $table->bigInteger('created_by');
            $table->softDeletes();
            $table->timestamps();

            $table->foreign('phs_id')->references('id')->on('position_has_salaries')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection(env('HRJP_DB_CONNECTION'))->dropIfExists('job_post_expenses');
    }
}
