<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateTableForFilePathApplicationForm extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection(env('HRJP_DB_CONNECTION'))->create('appointment_form_files', function(Blueprint $table){
            $table->id();
            $table->unsignedBigInteger('appointment_form_id');
            $table->text('file_path');
            $table->bigInteger('created_by');
            $table->timestamps();

            $table->foreign('appointment_form_id')->references('id')->on('appointment_forms')->onDelete('cascade');
        });

        Schema::connection(env('HRJP_DB_CONNECTION'))->table('appointment_forms', function (Blueprint $table) {
            $table->dropColumn('file_path');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        DB::statement('SET FOREIGN_KEY_CHECKS = 0');
        Schema::connection(env('HRJP_DB_CONNECTION'))->dropIfExists('appointment_form_files');
        DB::statement('SET FOREIGN_KEY_CHECKS = 1');

        Schema::connection(env('HRJP_DB_CONNECTION'))->table('appointment_forms', function (Blueprint $table) {
            $table->text('file_path')->after('applicant_id');
        });
    }
}
