<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddPostStartToPositionHasSalaries extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection(env('HRJP_DB_CONNECTION'))->table('position_has_salaries', function(Blueprint $table){
            $table->date('post_start')->nullable()->after('post_due');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection(env('HRJP_DB_CONNECTION'))->table('position_has_salaries', function(Blueprint $table){
            
            $table->dropColumn('post_start');

        });
    }
}
