<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddNewColumnItemCodePositionHistories extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection(env('HRJP_DB_CONNECTION'))->table('position_histories', function(Blueprint $table){
            $table->unsignedBigInteger('item_code_id')->nullable()->after('user_id');

            $table->foreign('item_code_id')->references('id')->on(env('HRJP_DB_DATABASE').'.item_codes');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection(env('HRJP_DB_CONNECTION'))->table('position_histories', function(Blueprint $table){
            $table->dropForeign(['item_code_id']);
            $table->dropColumn('item_code_id');
        });
    }
}
