<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddColumnQualificationStandardInPositionHasSalaries extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection(env('HRJP_DB_CONNECTION'))->table('position_has_salaries', function (Blueprint $table) {
            $table->string('education')->nullable()->after('description');
            $table->string('training')->nullable()->after('education');
            $table->string('experience')->nullable()->after('training');
            $table->string('eligibility')->nullable()->after('experience');
            $table->string('place_of_assignment')->nullable()->after('eligibility');
            $table->text('description')->nullable()->change();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection(env('HRJP_DB_CONNECTION'))->table('position_has_salaries', function (Blueprint $table) {
            $table->dropColumn('education');
            $table->dropColumn('training');
            $table->dropColumn('experience');
            $table->dropColumn('eligibility');
            $table->dropColumn('place_of_assignment');
            $table->text('description')->nullable(false)->change();
        });
    }
}
