<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddNewColumnItemCodeEmployeeMetaInfo extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection(env('ADG_DB_CONNECTION'))->table('employee_meta_info', function(Blueprint $table){
            $table->unsignedBigInteger('item_code_id')->nullable()->after('salary_id');

            $table->foreign('item_code_id')->references('id')->on(env('HRJP_DB_DATABASE').'.item_codes');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection(env('ADG_DB_CONNECTION'))->table('employee_meta_info', function(Blueprint $table){
            $table->dropForeign(['item_code_id']);
            $table->dropColumn('item_code_id');
        });
    }
}
