<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddColumnInitialInterviewReschedule extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection('hrjp_db')->table('applicant_init_int_resched', function (Blueprint $table) {
            $table->bigInteger('applicant_id')->after('id')->unsigned()->nullable();
 
            $table->foreign('applicant_id')->references('id')->on('applicant_accounts')->onDelete('cascade');
         });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection('hrjp_db')->table('applicant_init_int_resched', function (Blueprint $table) {
            $table->dropForeign('applicant_init_int_resched_applicant_id_foreign');
            $table->dropColumn('applicant_id');
        });
    }
}
