<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddAttachmentColumnToSupplementalRequirementUsers extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection('hrjp_db')->table('supplemental_requirement_users', function (Blueprint $table) {
            $table->text('attachment')->after('supplemental_req_id')->nullable();
            $table->bigInteger('status')->after('attachment')->comment('1 - pending, 2 - approved, 3 - declined')->nullable();  
            $table->text('justification')->after('status')->nullable();        
           });

        }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection('hrjp_db')->table('supplemental_requirement_users', function (Blueprint $table) {
            $table->dropColumn('attachment');
            $table->dropColumn('status');
            $table->dropColumn('justification');
        });
    }
}
