<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddNewColumnReschedule extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection(env('HRJP_DB_CONNECTION'))->table('applicant_exam_interview_reschedules', function (Blueprint $table) {
            $table->string('reason')->nullable()->after('interview_schedule');
        });

        Schema::connection(env('HRJP_DB_CONNECTION'))->table('applicant_exam_reschedules', function (Blueprint $table) {
            $table->string('reason')->nullable()->after('exam_schedule');
        });

        Schema::connection(env('HRJP_DB_CONNECTION'))->table('applicant_init_int_resched', function (Blueprint $table) {
            $table->string('reason')->nullable()->after('initial_interview_schedule');
        });

        Schema::connection(env('HRJP_DB_CONNECTION'))->table('applicant_exam_schedules', function (Blueprint $table) {
            $table->bigInteger('status')->comment('1 - pending, 2 - passed, 3 - tagged to other position, 4 - reschedule', '5 - failed')->change();
        });

        Schema::connection(env('HRJP_DB_CONNECTION'))->table('applicant_initial_interviews', function (Blueprint $table) {
            $table->bigInteger('status')->comment('1 - pending, 2 - passed, 3 - tagged to other position, 4 - reschedule', '5 - failed')->change();
        });

        Schema::connection(env('HRJP_DB_CONNECTION'))->table('applicant_exam_interviews', function (Blueprint $table) {
            $table->bigInteger('status')->comment('1 - pending, 2 - passed, 3 - tagged to other position, 4 - reschedule', '5 - failed')->change();
        });

    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection(env('HRJP_DB_CONNECTION'))->table('applicant_exam_interview_reschedules', function (Blueprint $table) {
            $table->dropColumn('reason');
        });

        Schema::connection(env('HRJP_DB_CONNECTION'))->table('applicant_exam_reschedules', function (Blueprint $table) {
            $table->dropColumn('reason');
        });

        Schema::connection(env('HRJP_DB_CONNECTION'))->table('applicant_init_int_resched', function (Blueprint $table) {
            $table->dropColumn('reason');
        });

        Schema::connection(env('HRJP_DB_CONNECTION'))->table('applicant_exam_schedules', function (Blueprint $table) {
            $table->bigInteger('status')->comment('1 - pending, 2 - passed, 3 - failed, 4 - reschedule')->change();
        });

        Schema::connection(env('HRJP_DB_CONNECTION'))->table('applicant_initial_interviews', function (Blueprint $table) {
            $table->bigInteger('status')->comment('1 - pending, 2 - passed, 3 - failed, 4 - reschedule')->change();
        });

        Schema::connection(env('HRJP_DB_CONNECTION'))->table('applicant_exam_interviews', function (Blueprint $table) {
            $table->bigInteger('status')->comment('1 - pending, 2 - passed, 3 - failed, 4 - reschedule')->change();
        });
    }
}
