<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddColumnToPositionHasSalaries extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
         Schema::connection('hrjp_db')->table('position_has_salaries', function (Blueprint $table) {
            $table->dropColumn('item_code');
            $table->unsignedBigInteger('item_code_id')->nullable()->after('id');
            // Add a foreign key constraint
            $table->foreign('item_code_id')->references('id')->on(env('HRJP_DB_DATABASE') . '.item_codes');
         });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection('hrjp_db')->table('position_has_salaries', function (Blueprint $table) {
            $table->string('item_code')->nullable();
            $table->dropForeign('position_has_salaries_item_code_id_foreign');
            $table->dropIndex('position_has_salaries_item_code_id_foreign');
            $table->dropColumn('item_code_id');
        }); 
    }
}
