<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateItemCodesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection('hrjp_db')->create('item_codes', function (Blueprint $table) {
            $table->id();
            $table->string('item_code');
            $table->unsignedBigInteger('position_id');
            $table->string('description')->nullable();
            $table->integer('status')->comment('1 = active, 2 = inactive, 3 = available')->default(1);
            $table->softDeletes();
            $table->timestamps();

            $table->foreign('position_id')->references('id')->on(env('HRJP_DB_DATABASE') . '.positions');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('item_codes');
    }
}