<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddNewForeignKeyGroupId extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection('hrjp_db')->table('positions', function (Blueprint $table) {
            $table->unsignedBigInteger('group_id')->after('title')->index()->nullable();

            $table->foreign('group_id')->references('id')->on(env('ADG_DB_DATABASE') . '.roster_groups');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection('hrjp_db')->table('positions', function (Blueprint $table) {
            $table->dropColumn('group_id');
        });
    }
}
