<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateApplicantPreEmploymentInfoTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection('hrjp_db')->create('applicant_pre_employment_info', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('pre_employment_field');
            $table->string('field_name');
            $table->string('field_value');
            $table->string('field_type')->comment('text, select, checkbox, radio');
            $table->integer('field_status')->comment('1 - enabled, 2 - disabled');
            $table->integer('created_by')->nullable();
            $table->integer('updated_by')->nullable();
            $table->softDeletes();
            $table->timestamps();

            $table->foreign('pre_employment_field')->references('id')->on('applicant_pre_employment_fields')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection('hrjp_db')->dropIfExists('applicant_pre_employment_info');
    }
}
