<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddColumnExamReschedule extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection('hrjp_db')->table('applicant_exam_reschedules', function (Blueprint $table) {
           $table->bigInteger('applicant_id')->after('id')->unsigned();

           $table->foreign('applicant_id')->references('id')->on('applicant_accounts')->onDelete('cascade');
        });
    
    }   

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection('hrjp_db')->table('applicant_exam_reschedules', function (Blueprint $table) {
            $table->dropColumn('applicant_id');
        });
    }
}
