<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateSupplementalDetailsUsersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection('hrjp_db')->create('supplemental_details_users', function (Blueprint $table) {
            $table->id();
            $table->bigInteger('applicant_req_id')->unsigned();
            $table->bigInteger('supplemental_detail_id')->unsigned();
            $table->softDeletes();
            $table->timestamps();

            $table->foreign('applicant_req_id')->references('id')->on('applicant_requirements')->onDelete('cascade');
            $table->foreign('supplemental_detail_id')->references('id')->on('supplemental_details')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('supplemental_details_users');
    }
}
