<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateSupplementalRequirementUsersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection('hrjp_db')->create('supplemental_requirement_users', function (Blueprint $table) {
            $table->id();
            $table->bigInteger('applicant_req_id')->unsigned();
            $table->bigInteger('supplemental_req_id')->unsigned();
            $table->softDeletes();
            $table->timestamps();

            $table->foreign('applicant_req_id')->references('id')->on('applicant_requirements')->onDelete('cascade');
            $table->foreign('supplemental_req_id')->references('id')->on('supplemental_requirements')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('supplemental_requirement_users');
    }
}
