<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddColumnToApplicantExamInterviewsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection('hrjp_db')->table('applicant_exam_interviews', function (Blueprint $table) {
            $table->string('interviewer')->after('schedule')->nullable();
            $table->string('zoomlink', 255)->after('interviewer')->nullable();
            $table->string('description', 255)->after('zoomlink')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection('hrjp_db')->table('applicant_exam_interviews', function (Blueprint $table) {
            $table->dropColumn('interviewer');
            $table->dropColumn('zoomlink');
            $table->dropColumn('description');
        });
    }
}
