<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddColumnToApplicantExamSchedule extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection('hrjp_db')->table('applicant_exam_schedules', function (Blueprint $table) {
            $table->string('proctor')->after('schedule')->nullable();
            $table->string('zoomlink', 255)->after('proctor')->nullable();
            $table->string('description', 255)->after('zoomlink')->nullable();
            $table->string('justification', 255)->after('description')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection('hrjp_db')->table('applicant_exam_schedules', function (Blueprint $table) {
            $table->dropColumn('proctor');
            $table->dropColumn('zoomlink');
            $table->dropColumn('description');
            $table->dropColumn('justification');
        });
    }
}
