<?php


use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateSupplementalDetailsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection('hrjp_db')->create('supplemental_details', function (Blueprint $table) {
            $table->id();
            $table->string('title', 255);
            $table->bigInteger('status');
            $table->string('additional_info', 255);
            $table->bigInteger('purpose')->comment('1 = For professional licensed position, 2 =  For administrative positions, 3 = For other positions in the government service,
            4 = Philhealth form, 5 = BIR form');
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('supplemental_details');
    }
}
